/****
* fVDI structure declarations, by Johan Klockars
*
* Most assembly files in the fVDI engine, as well as in its
* device drivers, need to include this file.
*
* Since it would be difficult to do without this file when
* writing new device drivers, and to make it possible for
* some such drivers to be commercial, this file is put in
* the public domain. It is not copyrighted or under any sort
* of license.
****/

#include "config.h"

#define vwk_real_address		0
#define vwk_standard_handle		4
#define vwk_text		6
#define vwk_text_font		6
#define vwk_text_colour		8
#define vwk_text_colour_background		8
#define vwk_text_colour_foreground		10
#define vwk_text_rotation		12
#define vwk_text_alignment		14
#define vwk_text_alignment_horizontal		14
#define vwk_text_alignment_vertical		16
#define vwk_text_character		18
#define vwk_text_character_width		18
#define vwk_text_character_height		20
#define vwk_text_cell		22
#define vwk_text_cell_width		22
#define vwk_text_cell_height		24
#define vwk_text_effects		26
#ifdef FVDI_STRUCT_2006
#define vwk_text_charmap		28
#define vwk_text_current_font		30
#define vwk_line		34
#define vwk_line_type		34
#define vwk_line_colour		36
#define vwk_line_colour_background		36
#define vwk_line_colour_foreground		38
#define vwk_line_ends		40
#define vwk_line_ends_beginning		40
#define vwk_line_ends_end		42
#define vwk_line_width		44
#define vwk_line_user_mask		46
#define vwk_bezier		48
#define vwk_bezier_on		48
#define vwk_bezier_depth_scale		50
#define vwk_marker		52
#define vwk_marker_type		52
#define vwk_marker_colour		54
#define vwk_marker_colour_background		54
#define vwk_marker_colour_foreground		56
#define vwk_marker_size		58
#define vwk_marker_size_width		58
#define vwk_marker_size_height		60
#define vwk_fill		62
#define vwk_fill_interior		62
#define vwk_fill_colour		64
#define vwk_fill_colour_background		64
#define vwk_fill_colour_foreground		66
#define vwk_fill_style		68
#define vwk_fill_perimeter		70
#define vwk_fill_user		72
#define vwk_fill_user_pattern		72
#define vwk_fill_user_pattern_in_use		72
#define vwk_fill_user_pattern_extra		76
#define vwk_fill_user_multiplane		80
#define vwk_console		82
#define vwk_console_cursor		82
#define vwk_console_reversed		84
#define vwk_console_pos		86
#define vwk_console_pos_x		86
#define vwk_console_pos_y		88
#define vwk_clip		90
#define vwk_clip_on		90
#define vwk_clip_rectangle		92
#define vwk_clip_rectangle_x1		92
#define vwk_clip_rectangle_y1		94
#define vwk_clip_rectangle_x2		96
#define vwk_clip_rectangle_y2		98
#define vwk_mode		100
#define vwk_palette		102
#define vwk_struct_size		106
#else /* !VDI_STRUCT_2006 */
#define vwk_text_current_font		28
#define vwk_line		32
#define vwk_line_type		32
#define vwk_line_colour		34
#define vwk_line_colour_background		34
#define vwk_line_colour_foreground		36
#define vwk_line_ends		38
#define vwk_line_ends_beginning		38
#define vwk_line_ends_end		40
#define vwk_line_width		42
#define vwk_line_user_mask		44
#define vwk_bezier		46
#define vwk_bezier_on		46
#define vwk_bezier_depth_scale		48
#define vwk_marker		50
#define vwk_marker_type		50
#define vwk_marker_colour		52
#define vwk_marker_colour_background		52
#define vwk_marker_colour_foreground		54
#define vwk_marker_size		56
#define vwk_marker_size_width		56
#define vwk_marker_size_height		58
#define vwk_fill		60
#define vwk_fill_interior		60
#define vwk_fill_colour		62
#define vwk_fill_colour_background		62
#define vwk_fill_colour_foreground		64
#define vwk_fill_style		66
#define vwk_fill_perimeter		68
#define vwk_fill_user		70
#define vwk_fill_user_pattern		70
#define vwk_fill_user_pattern_in_use		70
#define vwk_fill_user_pattern_extra		74
#define vwk_fill_user_multiplane		78
#define vwk_console		80
#define vwk_console_cursor		80
#define vwk_console_reversed		82
#define vwk_console_pos		84
#define vwk_console_pos_x		84
#define vwk_console_pos_y		86
#define vwk_clip		88
#define vwk_clip_on		88
#define vwk_clip_rectangle		90
#define vwk_clip_rectangle_x1		90
#define vwk_clip_rectangle_y1		92
#define vwk_clip_rectangle_x2		94
#define vwk_clip_rectangle_y2		96
#define vwk_mode		98
#define vwk_palette		100
#define vwk_struct_size		104
#endif /* FVDI_STRUCT_2006 */

#define wk_driver		0
#define wk_screen		4
#define wk_screen_type		4
#define wk_screen_colour		6
#define wk_screen_bkg_colours		8
#define wk_screen_look_up_table		10
#define wk_screen_palette		12
#define wk_screen_palette_possibilities		12
#define wk_screen_palette_size		14
#define wk_screen_palette_colours		16
#define wk_screen_palette_transformation		20
#define wk_screen_mfdb		24
#define wk_screen_mfdb_address		24
#define wk_screen_mfdb_width		28
#define wk_screen_mfdb_height		30
#define wk_screen_mfdb_wdwidth		32
#define wk_screen_mfdb_standard		34
#define wk_screen_mfdb_bitplanes		36
#define wk_screen_mfdb_reserved		38
#define wk_screen_wrap		44
#define wk_screen_linea		46
#define wk_screen_shadow		50
#define wk_screen_shadow_buffer		50
#define wk_screen_shadow_address		54
#define wk_screen_shadow_wrap		58
#define wk_screen_pixel		60
#define wk_screen_pixel_width		60
#define wk_screen_pixel_height		62
#define wk_screen_coordinates		64
#define wk_screen_coordinates_course		64
#define wk_screen_coordinates_min_x		66
#define wk_screen_coordinates_min_y		68
#define wk_screen_coordinates_max_x		70
#define wk_screen_coordinates_max_y		72
#define wk_writing		74
#define wk_writing_fonts		74
#define wk_writing_first_font		76
#define wk_writing_effects		80
#define wk_writing_rotation		82
#define wk_writing_rotation_possible		82
#define wk_writing_rotation_type		84
#define wk_writing_justification		86
#define wk_writing_size		88
#define wk_writing_size_possibilities		88
#define wk_writing_size_height		90
#define wk_writing_size_height_min		90
#define wk_writing_size_height_max		92
#define wk_writing_size_width		94
#define wk_writing_size_width_min		94
#define wk_writing_size_width_max		96
#define wk_drawing		98
#define wk_drawing_primitives		98
#define wk_drawing_primitives_supported		98
#define wk_drawing_primitives_attributes		100
#define wk_drawing_rubber_banding		104
#define wk_drawing_flood_fill		106
#define wk_drawing_writing_modes		108
#define wk_drawing_fill		110
#define wk_drawing_fill_possible		110
#define wk_drawing_fill_patterns		112
#define wk_drawing_fill_hatches		114
#define wk_drawing_marker		116
#define wk_drawing_marker_types		116
#define wk_drawing_marker_size		118
#define wk_drawing_marker_size_possibilities		118
#define wk_drawing_marker_size_height		120
#define wk_drawing_marker_size_height_min		120
#define wk_drawing_marker_size_height_max		122
#define wk_drawing_marker_size_width		124
#define wk_drawing_marker_size_width_min		124
#define wk_drawing_marker_size_width_max		126
#define wk_drawing_line		128
#define wk_drawing_line_types		128
#define wk_drawing_line_wide		130
#define wk_drawing_line_wide_width		130
#define wk_drawing_line_wide_width_possibilities		130
#define wk_drawing_line_wide_width_max		132
#define wk_drawing_line_wide_width_min		134
#define wk_drawing_line_wide_types_possible		136
#define wk_drawing_line_wide_writing_modes		138
#define wk_drawing_bezier		140
#define wk_drawing_bezier_available		140
#define wk_drawing_bezier_depth_scale		142
#define wk_drawing_bezier_depth_scale_min		142
#define wk_drawing_bezier_depth_scale_max		144
#define wk_drawing_bezier_depth		146
#define wk_drawing_bezier_depth_min		146
#define wk_drawing_bezier_depth_max		148
#define wk_drawing_cellarray		150
#define wk_drawing_cellarray_available		150
#define wk_raster		152
#define wk_raster_scaling		152
#define wk_raster_performance		154
#define wk_various		156
#define wk_various_input_type		156
#define wk_various_inking		158
#define wk_various_max_ptsin		160
#define wk_various_max_intin		162
#define wk_various_buttons		164
#define wk_various_cursor_movement		166
#define wk_various_number_entry		168
#define wk_various_selection		170
#define wk_various_typing		172
#define wk_various_workstation_type		174
#define wk_mouse		176
#define wk_mouse_type		176
#define wk_mouse_hide		178
#define wk_mouse_buttons		180
#define wk_mouse_forced		182
#define wk_mouse_position		184
#define wk_mouse_position_x		184
#define wk_mouse_position_y		186
#define wk_mouse_hotspot		188
#define wk_mouse_hotspot_x		188
#define wk_mouse_hotspot_y		190
#define wk_mouse_colour		192
#define wk_mouse_colour_background		192
#define wk_mouse_colour_foreground		194
#define wk_mouse_mask		196
#define wk_mouse_data		228
#define wk_mouse_extra_info		260
#define wk_vector		264
#define wk_vector_motion		264
#define wk_vector_draw		268
#define wk_vector_button		272
#define wk_vector_wheel		276
#define wk_vector_vblank		280
#define wk_vblank		284
#define wk_vblank_real		284
#define wk_vblank_frency		286
#define wk_r		288
#define wk_r_set_palette		288
#define wk_r_get_colour		292
#define wk_r_set_pixel		296
#define wk_r_get_pixel		300
#define wk_r_line		304
#define wk_r_expand		308
#define wk_r_fill		312
#define wk_r_fillpoly		316
#define wk_r_blit		320
#define wk_r_text		324
#define wk_r_mouse		328
#define wk_dummy		332
#define wk_dummy_retvals		332
#define wk_dummy_code		336
#define wk_function		340
#define wk_function_retvals		340
#define wk_function_code		344
#define wk_opcode5_count		2388
#define wk_opcode5		2390
#define wk_opcode11_count		2486
#define wk_opcode11		2488
#define wk_struct_size		2544

#define font_id		0
#define font_size		2
#define font_name		4
#define font_code		36
#define font_code_low		36
#define font_code_high		38
#define font_distance		40
#define font_distance_top		40
#define font_distance_ascent		42
#define font_distance_half		44
#define font_distance_descent		46
#define font_distance_bottom		48
#define font_widest		50
#define font_widest_character		50
#define font_widest_cell		52
#define font_offset		54
#define font_offset_left		54
#define font_offset_right		56
#define font_thickening		58
#define font_underline		60
#define font_lightening		62
#define font_skewing		64
#define font_flags		66
#define font_table		68
#define font_table_horizontal		68
#define font_table_character		72
#define font_data		76
#define font_width		80
#define font_height		82
#define font_next		84
#define font_extra		88
#define font_extra_distance		88
#define font_extra_distance_base		88
#define font_extra_distance_half		90
#define font_extra_distance_ascent		92
#define font_extra_distance_bottom		94
#define font_extra_distance_descent		96
#define font_extra_distance_top		98
#define font_extra_unpacked		100
#define font_extra_unpacked_data		100
#define font_extra_unpacked_format		104
#define font_extra_width_table		106
#define font_extra_next_size		110
#define font_extra_first_size		114
#ifdef FVDI_STRUCT_2006
#define font_extra_ref_count		118
#define font_extra_filename		120
#define font_extra_index		124
#define font_extra_current		126
#define font_extra_cache		130
#define font_extra_scratch		134
#define font_extra_effects		138
#define font_extra_underline_offset	140
#define font_struct_size		142
#else /* !FVDI_STRUCT_2006 */
#define font_extra_filename		118
#define font_extra_index		122
#define font_extra_current		124
#define font_extra_cache		128
#define font_extra_scratch		132
#define font_struct_size		136
#endif /* !FVDI_STRUCT_2006 */ 

#define mfdb_address		0
#define mfdb_width		4
#define mfdb_height		6
#define mfdb_wdwidth		8
#define mfdb_standard		10
#define mfdb_bitplanes		12
#define mfdb_reserved		14
#define mfdb_struct_size		20

#define colour_vdi		0
#define colour_vdi_red		0
#define colour_vdi_green		2
#define colour_vdi_blue		4
#define colour_hw		6
#define colour_hw_red		6
#define colour_hw_green		8
#define colour_hw_blue		10
#define colour_real		12
#define colour_struct_size		16

#define rgb_red		0
#define rgb_green		2
#define rgb_blue		4
#define rgb_struct_size		6

#define list_next		0
#define list_type		4
#define list_value		6
#define list_struct_size		10

#define driver_module		0
#define driver_module_id		0
#define driver_module_flags		2
#define driver_module_file_name		4
#define driver_module_name		8
#define driver_module_initialize		12
#define driver_module_setup		16
#define driver_module_shutdown		20
#define driver_module_private		24
#define driver_opnwk		28
#define driver_clswk		32
#define driver_default_vwk		36
#define driver_device		40
#define driver_struct_size		44

#define mouse_type		0
#define mouse_hide		2
#define mouse_buttons		4
#define mouse_forced		6
#define mouse_position		8
#define mouse_position_x		8
#define mouse_position_y		10
#define mouse_hotspot		12
#define mouse_hotspot_x		12
#define mouse_hotspot_y		14
#define mouse_colour		16
#define mouse_colour_background		16
#define mouse_colour_foreground		18
#define mouse_mask		20
#define mouse_data		52
#define mouse_extra_info		84
#define mouse_struct_size		88

#define dev_format		0
#define dev_clut		2
#define dev_bit_depth		4
#define dev_dummy1		6
#define dev_colours		8
#define dev_byte_width		10
#define dev_address		12
#define dev_bits		16
#define dev_bits_red		16
#define dev_bits_green		18
#define dev_bits_blue		20
#define dev_bits_alpha		22
#define dev_bits_genlock		24
#define dev_bits_unused		26
#define dev_bits_organization		28
#define dev_dummy2		30
#define dev_vdi2pix		32
#define dev_bitnumber		32
#define dev_bitnumber_red		32
#define dev_bitnumber_green		64
#define dev_bitnumber_blue		96
#define dev_bitnumber_alpha		128
#define dev_bitnumber_genlock		160
#define dev_bitnumber_unused		192
#define dev_bitnumber_reserved		256
#define dev_struct_size		544

#define drvline_x1		0
#define drvline_y1		4
#define drvline_x2		8
#define drvline_y2		12
#define drvline_pattern		16
#define drvline_colour		20
#define drvline_mode		24
#define drvline_draw_last		28
#define drvline_struct_size		32

#define drvpalette_first_pen		0
#define drvpalette_count		4
#define drvpalette_requested		8
#define drvpalette_palette		12
#define drvpalette_struct_size		16
